import React from 'react';
import { Route, Switch } from 'react-router-dom';

import Header from './layout/Header';
import Signin from './Signin';

import './home.less';

const Home = () => {
  // Type assertions needed for React 18 compatibility with react-router-dom v5 types
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const SwitchComponent = Switch as any;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const RouteComponent = Route as any;

  return (
    <div className="home-container">
      <header className="home-content-header">
        <Header />
      </header>
      <main className="home-content-main main-content-container">
        <SwitchComponent>
          <RouteComponent exact path={`/`} component={Signin} />
          <RouteComponent path={`/signin`} component={Signin} />
        </SwitchComponent>
      </main>
    </div>
  );
};

export default Home;
