package controllers

import (
	"net/http"
	"strconv"

	"github.com/genshen/ssh-web-console/src/models"
	"github.com/genshen/ssh-web-console/src/utils"
	"golang.org/x/crypto/ssh"
)

func SignIn(w http.ResponseWriter, r *http.Request) {
	if r.Method != "POST" {
		http.Error(w, "Invalid request method.", 405)
	} else {
		var err error
		var errUnmarshal models.JsonResponse
		err = r.ParseForm()
		if err != nil {
			panic(err)
		}
		userinfo := models.UserInfo{}
		userinfo.Host = r.Form.Get("host")
		port := r.Form.Get("port")
		userinfo.Username = r.Form.Get("username")
		userinfo.Password = r.Form.Get("passwd")

		userinfo.Port, err = strconv.Atoi(port)
		if err != nil {
			userinfo.Port = 22
		}

		if userinfo.Host != "" && userinfo.Username != "" {
			//try to login session account
			session := utils.SSHShellSession{}
			session.Node = utils.NewSSHNode(userinfo.Host, userinfo.Port)
			err := session.Connect(userinfo.Username, ssh.Password(userinfo.Password))
			if err != nil {
				// Incluir mensaje de error SSH detallado
				errorDetail := err.Error()
				errUnmarshal = models.JsonResponse{
					HasError:    true,
					Message:     models.SIGN_IN_FORM_TYPE_ERROR_PASSWORD,
					ErrorDetail: errorDetail,
				}
			} else {
				defer session.Close()
				// create session
				client, err := session.GetClient()
				if err != nil {
					// bad connection.
					errUnmarshal = models.JsonResponse{
						HasError:    true,
						Message:     models.SIGN_IN_FORM_TYPE_ERROR_TEST,
						ErrorDetail: "Error al obtener cliente SSH: " + err.Error(),
					}
					utils.ServeJSON(w, errUnmarshal)
					return
				}
				if session, err := client.NewSession(); err == nil {
					if err := session.Run("whoami"); err == nil {
						if token, expireUnix, err := utils.JwtNewToken(userinfo.JwtConnection, utils.Config.Jwt.Issuer); err == nil {
							errUnmarshal = models.JsonResponse{HasError: false, Addition: token}
							utils.ServeJSON(w, errUnmarshal)
							utils.SessionStorage.Put(token, expireUnix, userinfo)
							return
						} else {
							// Error al crear token JWT
							errUnmarshal = models.JsonResponse{
								HasError:    true,
								Message:     models.SIGN_IN_FORM_TYPE_ERROR_TEST,
								ErrorDetail: "Error al crear token JWT: " + err.Error(),
							}
						}
					} else {
						// Error al ejecutar whoami
						errUnmarshal = models.JsonResponse{
							HasError:    true,
							Message:     models.SIGN_IN_FORM_TYPE_ERROR_TEST,
							ErrorDetail: "Error al ejecutar comando de prueba (whoami): " + err.Error(),
						}
					}
				} else {
					// Error al crear sesión SSH
					errUnmarshal = models.JsonResponse{
						HasError:    true,
						Message:     models.SIGN_IN_FORM_TYPE_ERROR_TEST,
						ErrorDetail: "Error al crear sesión SSH: " + err.Error(),
					}
				}
			}
		} else {
			errUnmarshal = models.JsonResponse{HasError: true, Message: models.SIGN_IN_FORM_TYPE_ERROR_VALID}
		}
		utils.ServeJSON(w, errUnmarshal)
	}
}
