@echo off
setlocal

set "ROOT_DIR=C:\wamp64\www\web-console"
set "WEB_DIR=%ROOT_DIR%\web"
set "STATIK_PATH=C:\ProgramasGo\bin\statik.exe"

echo ========================================
echo   Build y Ejecucion de Web-Console
echo ========================================
echo.

echo [1/4] Compilando frontend React...
pushd "%WEB_DIR%"
if %ERRORLEVEL% NEQ 0 (
    echo ERROR: No se pudo cambiar al directorio web
    pause
    exit /b 1
)

call yarn build
if %ERRORLEVEL% NEQ 0 (
    echo.
    echo ERROR: Fallo la compilacion del frontend
    popd
    pause
    exit /b 1
)

popd
echo.
echo OK: Frontend compilado exitosamente
echo.

echo [2/4] Ejecutando Statik...
pushd "%ROOT_DIR%"
if %ERRORLEVEL% NEQ 0 (
    echo ERROR: No se pudo cambiar al directorio raiz
    pause
    exit /b 1
)

"%STATIK_PATH%" --src=web/build
if %ERRORLEVEL% NEQ 0 (
    echo.
    echo ERROR: Fallo la ejecucion de Statik
    popd
    pause
    exit /b 1
)

echo.
echo OK: Statik ejecutado exitosamente
echo.

echo [3/4] Compilando servidor Go...
go build -o ssh-web-console.exe
if %ERRORLEVEL% NEQ 0 (
    echo.
    echo ERROR: Fallo la compilacion del servidor Go
    popd
    pause
    exit /b 1
)

echo.
echo OK: Servidor Go compilado exitosamente
echo.

echo [4/4] Iniciando servidor web-console...
echo.
ssh-web-console.exe
if %ERRORLEVEL% NEQ 0 (
    echo.
    echo ERROR: El servidor se cerro con errores
    popd
    pause
    exit /b 1
)

popd
pause

