const { override, addLessLoader } = require('customize-cra');

// Función que ajusta PostCSS Loader DESPUÉS de que addLessLoader lo configura
const fixPostCSSLoaderAfterLess = (config) => {
  // Función recursiva para encontrar y ajustar PostCSS Loader en toda la configuración
  const fixPostCSSInRules = (rules) => {
    if (!rules || !Array.isArray(rules)) return;
    
    rules.forEach((rule) => {
      if (rule.oneOf) {
        fixPostCSSInRules(rule.oneOf);
      }
      
      if (rule.use) {
        const processUse = (use) => {
          if (Array.isArray(use)) {
            use.forEach((item) => {
              if (typeof item === 'object' && item !== null && item.loader) {
                if (item.loader.includes('postcss-loader') && item.options) {
                  // Si tiene plugins directamente (API antigua), moverlos a postcssOptions
                  if (item.options.plugins && !item.options.postcssOptions) {
                    item.options = {
                      postcssOptions: {
                        plugins: item.options.plugins
                      }
                    };
                  }
                }
              }
            });
          } else if (typeof use === 'object' && use !== null && use.loader) {
            if (use.loader.includes('postcss-loader') && use.options) {
              if (use.options.plugins && !use.options.postcssOptions) {
                use.options = {
                  postcssOptions: {
                    plugins: use.options.plugins
                  }
                };
              }
            }
          }
        };
        
        processUse(rule.use);
      }
    });
  };

  if (config.module && config.module.rules) {
    fixPostCSSInRules(config.module.rules);
  }

  return config;
};

module.exports = override(
  addLessLoader({
    lessOptions: {
      javascriptEnabled: true,
    }
  }),
  fixPostCSSLoaderAfterLess  // Aplicar el fix DESPUÉS de addLessLoader
)
