# Web Console - Guía de Instalación para Windows (Entorno Local)

Esta guía te ayudará a configurar y ejecutar el Web Console en un entorno local de Windows.

## Introducción

El Web Console es una aplicación web desarrollada en Go con frontend React que permite conectarse a servidores Linux mediante SSH directamente desde el navegador. Esta aplicación se integra con Cluster Panel para proporcionar una interfaz web para la gestión remota de servidores.

## Requisitos Previos

Antes de comenzar, asegúrate de tener instalado lo siguiente:

- **Go 1.13 o superior**: [Descargar Go](https://golang.org/dl/)
  - Verificar instalación: `go version`
- **Node.js 18**: [Descargar Node.js](https://nodejs.org/)
  - Verificar instalación: `node --version`
- **Yarn**: Se instala automáticamente con Node.js o puedes instalarlo con:
  ```bash
  npm install -g yarn
  ```
  - Verificar instalación: `yarn --version`
- **Statik**: Herramienta para embeber archivos estáticos en el binario Go
  - Instalación: `go install github.com/rakyll/statik@latest`
  - Nota: Asegúrate de que `%USERPROFILE%\go\bin` esté en tu PATH

## Instalación de Dependencias

### 1. Clonar o Navegar al Directorio del Proyecto

Si aún no tienes el código fuente, clónalo desde el repositorio o navega al directorio donde está ubicado:

```bash
cd C:\wamp64\www\web-console
```

### 2. Instalar Dependencias de Go

Las dependencias de Go se descargan automáticamente al compilar. Puedes verificar que están disponibles ejecutando:

```bash
go mod download
go mod verify
```

### 3. Instalar Dependencias del Frontend React

Navega al directorio `web` e instala las dependencias:

```bash
cd web
yarn install
cd ..
```

## Configuración

### 1. Configurar el Archivo de Configuración

El archivo de configuración principal se encuentra en `conf/config.yaml`. Este archivo controla la configuración del servidor.

Asegúrate de que el archivo `conf/config.yaml` existe y tiene una configuración similar a esta:

```yaml
site:
  appname: ssh-web-console
  listen_addr: :2222
  runmode: prod
  deploy_host: localhost

prod:
  # http path of static files and views
  static_prefix: /

dev: # config used in debug mode.
  # https prefix of static files only
  static_prefix: /static/
  # redirect static files requests to this address
  static_redirect: "localhost:8080"
  static_dir: ./dist/
  views_prefix: /
  views_dir: views/

ssh:
  buffer_checker_cycle_time: 60

jwt:
  jwt_secret: secret.local.console
  token_lifetime: 7200
  issuer: issuer.local.ssh
  query_token_key: _t
```

**Importante para desarrollo local:**

- `listen_addr: :2222` - Puerto en el que escuchará el servidor
- `runmode: prod` - Modo de ejecución (prod o dev)
- Ajusta el puerto si el 2222 ya está en uso

### 2. Configurar Variables de Entorno React (Producción)

Si estás compilando para producción, necesitas configurar las variables de entorno React antes de compilar el frontend.

Crea un archivo `.env` en el directorio `web/` con el siguiente contenido:

```env
REACT_APP_CLUSTER_URL=http://localhost:8000
REACT_APP_API_URL=localhost:2222
REACT_APP_ROUTER_BASE=
REACT_APP_API_HTTPS=false
```

**Nota:**

- `REACT_APP_CLUSTER_URL`: URL base de tu instalación de Cluster Panel (sin barra final)
- `REACT_APP_API_URL`: URL del servidor web console (opcional, por defecto usa window.location.host)
- Ajusta estas URLs según tu configuración local

Para desarrollo, estas variables son opcionales, pero se recomienda configurarlas si planeas usar la integración con Cluster Panel.

## Compilación Paso a Paso

### Método 1: Usando el Script build-and-run.bat (Recomendado)

El proyecto incluye un script batch que automatiza todo el proceso:

1. **Editar el Script (si es necesario):**

   Abre `build-and-run.bat` y verifica las rutas:

   - `ROOT_DIR`: Debe apuntar a tu directorio del proyecto
   - `STATIK_PATH`: Debe apuntar a la ubicación de `statik.exe`

   Ejemplo de configuración:

   ```batch
   set "ROOT_DIR=C:\wamp64\www\web-console"
   set "STATIK_PATH=C:\ProgramasGo\bin\statik.exe"
   ```

2. **Ejecutar el Script:**

   Simplemente ejecuta:

   ```bash
   build-and-run.bat
   ```

   El script:

   - Compilará el frontend React
   - Ejecutará Statik para embeber los archivos estáticos
   - Compilará el servidor Go
   - Iniciará el servidor automáticamente

### Método 2: Compilación Manual

Si prefieres hacerlo paso a paso o el script no funciona, sigue estos pasos:

#### Paso 1: Compilar el Frontend React

```bash
cd web
yarn build
cd ..
```

Esto generará los archivos estáticos en `web/build/`.

#### Paso 2: Generar Archivos Statik

Statik embebe los archivos estáticos del frontend en el código Go:

```bash
statik --src=web/build
```

Esto generará archivos en el directorio `statik/`.

#### Paso 3: Compilar el Servidor Go

```bash
go build -o ssh-web-console.exe
```

Esto generará el ejecutable `ssh-web-console.exe` en el directorio actual.

## Ejecución

### Opción 1: Ejecución Directa

Si compilaste manualmente, ejecuta el binario:

```bash
ssh-web-console.exe
```

### Opción 2: Especificar Archivo de Configuración Personalizado

Si quieres usar un archivo de configuración en otra ubicación:

```bash
ssh-web-console.exe -config ruta/a/otro/config.yaml
```

### Opción 3: Ejecutar con build-and-run.bat

El script `build-and-run.bat` compila y ejecuta automáticamente.

## Verificación

1. **Verificar que el Servidor está Ejecutándose:**

   El servidor debería mostrar un mensaje como:

   ```
   listening on port  :2222
   ```

2. **Acceder desde el Navegador:**

   Abre tu navegador y visita:

   ```
   http://localhost:2222
   ```

   Deberías ver la interfaz de login del Web Console.

3. **Probar Conexión SSH:**

   Ingresa:

   - Host: IP o hostname del servidor al que quieres conectarte
   - Puerto: 22 (por defecto)
   - Usuario: Tu usuario SSH
   - Contraseña: Tu contraseña SSH

## Integración con Cluster Panel

Para que el Web Console funcione integrado con Cluster Panel:

1. **Configurar la URL en Cluster Panel:**

   En la configuración de Cluster Panel, asegúrate de que `urlWebConsole` esté configurada con la URL del Web Console:

   ```
   http://localhost:2222
   ```

2. **Variable de Entorno REACT_APP_CLUSTER_URL:**

   Al compilar el frontend, la variable `REACT_APP_CLUSTER_URL` debe apuntar a la URL de tu Cluster Panel:

   ```env
   REACT_APP_CLUSTER_URL=http://localhost:8000
   ```

   (Ajusta el puerto según tu configuración de Cluster Panel)

3. **Probar la Integración:**

   Desde Cluster Panel, al acceder a la opción de Web Console, debería cargarse el Web Console en un iframe con las credenciales ya configuradas.

## Solución de Problemas Comunes

### Error: "statik: command not found"

**Solución:**

1. Instala Statik: `go install github.com/rakyll/statik@latest`
2. Asegúrate de que `%USERPROFILE%\go\bin` esté en tu PATH
3. Reinicia la terminal después de agregar al PATH

### Error: "yarn: command not found"

**Solución:**

1. Instala Node.js desde [nodejs.org](https://nodejs.org/)
2. Instala Yarn globalmente: `npm install -g yarn`
3. Verifica la instalación: `yarn --version`

### Error: "port 2222 already in use"

**Solución:**

1. Cambia el puerto en `conf/config.yaml`:
   ```yaml
   listen_addr: :2223
   ```
2. O cierra el proceso que está usando el puerto 2222

### Error al compilar el frontend: "openssl-legacy-provider"

**Solución:**
El script de compilación ya incluye la opción `NODE_OPTIONS=--openssl-legacy-provider` en `package.json`. Si aún tienes problemas:

1. Actualiza Node.js a una versión más reciente
2. O ejecuta manualmente: `set NODE_OPTIONS=--openssl-legacy-provider && yarn build`

### El Web Console no se conecta con Cluster Panel

**Solución:**

1. Verifica que `REACT_APP_CLUSTER_URL` esté configurada correctamente en el archivo `.env` del directorio `web/`
2. Recompila el frontend después de cambiar las variables de entorno
3. Verifica que la URL de Cluster Panel en `urlWebConsole` coincida con la URL donde está ejecutándose

### Problemas de CORS o postMessage

**Solución:**

1. Asegúrate de que `REACT_APP_CLUSTER_URL` apunte exactamente a la URL de Cluster Panel (mismo protocolo, dominio y puerto)
2. Verifica que ambos servicios estén ejecutándose
3. Revisa la consola del navegador para ver errores específicos

## Referencias Adicionales

- **Repositorio del Proyecto**: [ssh-web-console](https://github.com/genshen/ssh-web-console)
- **Documentación de Go**: [golang.org/doc](https://golang.org/doc/)
- **Documentación de React**: [react.dev](https://react.dev/)
- **Documentación de Statik**: [github.com/rakyll/statik](https://github.com/rakyll/statik)

## Notas Adicionales

- Para desarrollo, puedes usar `runmode: dev` en `config.yaml` para habilitar características de desarrollo
- El servidor acepta conexiones desde cualquier IP. En producción, considera agregar restricciones de seguridad
- Las credenciales SSH no se almacenan en el servidor, se envían directamente a través de WebSocket
- El Web Console usa JWT para autenticación de sesiones SSH

## Comandos Rápidos de Referencia

```bash
# Compilar frontend
cd web && yarn build && cd ..

# Generar statik
statik --src=web/build

# Compilar servidor
go build -o ssh-web-console.exe

# Ejecutar servidor
ssh-web-console.exe

# Ejecutar todo con el script
build-and-run.bat
```
